implementation module receiverevent


//	Clean Object I/O library, version 1.0.1


import StdBool
import devicefunctions, iostate


/*	receiverEvent filters the appropriate events for the receiver device.
	These are only the message events (as long as receivers do not contain timers).
*/
receiverEvent :: !(SchedulerEvent i o) !(IOSt .l .p) -> (!Bool, !Maybe (DeviceEvent i o),!SchedulerEvent i o,!IOSt .l .p)
receiverEvent schedulerEvent=:(ScheduleMsgEvent msgEvent) ioState
	# (ioid,ioState)= IOStGetIOId ioState
	  recloc		= case msgEvent of
	  					(QASyncMessage {qasmRecLoc}) -> qasmRecLoc
	  					(ASyncMessage  { asmRecLoc}) -> asmRecLoc
	  					(SyncMessage   {  smRecLoc}) -> smRecLoc
	| ioid==recloc.rlIOId && ReceiverDevice==recloc.rlDevice
	= (True, Just (ReceiverEvent msgEvent),schedulerEvent,ioState)
	= (False,Nothing,schedulerEvent,ioState)
receiverEvent schedulerEvent ioState
	= (False,Nothing,schedulerEvent,ioState)
